﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0080_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

Try {
    $TabCompareSettings = Get-ItemPropertyValue 'HKLM:\Software\Policies\Google\Chrome' -Name TabCompareSettings
    if($TabCompareSettings -eq 2){
        Log-Message -message "TabCompareSettings configured value: $TabCompareSettings"
        Exit 0
    } else {
        Log-Message -message "TabCompareSettings configured incorrect value: $TabCompareSettings"
        Exit 1
    }
} Catch {
    Log-Message -message "The property does not exist or an error occurred: $_"
    Exit 1
}